/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var app = {
    initialize: function () {
        document.addEventListener('deviceready', this.onDeviceReady.bind(this), false);
    },

    onDeviceReady: function () {
        this.receivedEvent('deviceready');
    },

    receivedEvent: function (id) {
        var parentElement = document.getElementById(id);
    }
};

//prod
const appURL = `http://dev.visioncargo.net/`;

//test
// const appURL = `http://localhost:8000/`;

localStorage.setItem('locale', 'en');

app.initialize();
$(".content").hide();

document.addEventListener('deviceready', function () {
    cordova.plugins.backgroundMode.enable();
    cordova.plugins.backgroundMode.setDefaults({
        title: 'String',
        text: 'String',
        icon: 'icon',
        color: 'F14F4D',
        resume: 1,
        hidden: 1,
        bigText: 1
    });

    cordova.plugins.backgroundMode.onactivate = function () {  
    }
}, false);

function getCurrentLang(){
    return (localStorage.getItem('locale') == "pl") ? lang_pl : lang_en;
}

var lang = getCurrentLang();